﻿using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI;
using System.Linq;
using System.Windows.Forms;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public abstract class SelectableTestViewModel : NotifyPropertyChanged, ISelectableTestViewModel
    {
        private bool isSelected;
        public bool IsSelected
        {
            get
            {
                return isSelected;
            }
            set
            {
                isSelected = value;
                RaisePropertyChanged(() => IsSelected);
            }
        }

        private bool isSelectable;
        public bool IsSelectable
        {
            get
            {
                return isSelectable;
            }
            set
            {
                isSelectable = value;
                RaisePropertyChanged(() => IsSelectable);
            }
        }

        private string selectToolTip;
        public string SelectToolTip
        {
            get
            {
                return selectToolTip;
            }
            set
            {
                selectToolTip = value;
                RaisePropertyChanged(() => SelectToolTip);
            }
        }

        private IPendingTestModel pendingTestModel;
        public IPendingTestModel PendingTestModel
        {
            get
            {
                return pendingTestModel;
            }
            set
            {
                pendingTestModel = value;
                RaisePropertyChanged(() => PendingTestModel);
            }
        }

        private string _reviewComment;
        public string ReviewComment
        {
            get
            {
                return _reviewComment;
            }
            set
            {
                _reviewComment = value;
                RaisePropertyChanged(() => ReviewComment);
            }
        }

        private TestValidationModel _testValidation;
        public TestValidationModel TestValidation
        {
            get
            {
                return _testValidation;
            }
            set
            {
                _testValidation = value;
                RaisePropertyChanged(() => TestValidation);
            }
        }

        public SelectableTestViewModel(IPendingTestModel pendingTestModel)
        {
            IsSelectable = true;
            PendingTestModel = pendingTestModel;
        }

        public abstract bool IsDirty();

        /// <summary>
        /// PromptUserWithWarnings
        /// </summary>
        /// <param name="vbecsBaseForm"></param>
        internal void PromptUserWithWarnings(VbecsBaseForm vbecsBaseForm)
        {
            if (TestValidation == null ||
                TestValidation.UserWarningPromptList == null)
            {
                return;
            }

            foreach (var promptMessage in TestValidation.UserWarningPromptList)
            {
                GuiMessenger.ShowMessageBox(promptMessage);
            }
        }

        /// <summary>
        /// PromptForExceptionOverrides
        /// </summary>
        /// <param name="vbecsBaseForm"></param>
        internal void PromptForExceptionOverrides(VbecsBaseForm vbecsBaseForm)
        {
            if (TestValidation == null ||
                TestValidation.ExceptionForDisplayList == null)
            {
                return;
            }

            foreach (var exceptionForDisplay in TestValidation.ExceptionForDisplayList)
            {
                if (string.IsNullOrWhiteSpace(exceptionForDisplay.OverrideMessage))
                {
                    // User has already entered an override for this exception type
                    DlgOverrideComment dlg = new DlgOverrideComment(exceptionForDisplay.PromptCaption, 
                                                                    exceptionForDisplay.PromptMessage, 
                                                                    exceptionForDisplay.CannedCommentCategory);

                    // Show the dialog
                    dlg.ShowDialog(vbecsBaseForm);

                    if (dlg.DialogResult == DialogResult.OK)
                    {
                        exceptionForDisplay.OverrideMessage = dlg.Comment.Trim();
                    }
                    else
                    {
                        // User cancelled out of dialog
                        break;
                    }
                }
            }
        }

        /// <summary>
        /// Determines if all exceptions have an override message entered
        /// </summary>
        internal bool AreAllExceptionOverridesProcessed()
        {
            if (TestValidation != null &&
                TestValidation.ExceptionForDisplayList != null &&
                TestValidation.ExceptionForDisplayList.Any(x => string.IsNullOrWhiteSpace(x.OverrideMessage)))
            {
                return false;
            }

            return true;
        }
    }
}
